<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CovenantName extends Model 
{

    protected $table = 'covenant_name';
    public $timestamps = true;
    protected $fillable = array('category_id', 'type_id');

    public function category()
    {
        return $this->belongsTo('App\Models\Category');
    }

    public function type()
    {
        return $this->belongsTo('App\Models\Type');
    }

    public function covenants()
    {
        return $this->hasMany('App\Models\Covenant');
    }

}